
function AISMN_BanditAttackInitialize::OnEnter(%this, %data)
{
	%target = GetParameterTarget(%data);
	%object = GetThisObject(%data);
	
	%object.banditTarget = %target;
	
	// Get disaster target if there is one
	%disaster = $DisasterManager.getBanditAttack(%object);
	if(isObject(%disaster)) {
	   if(%disaster.getTarget() !$= "") {
	      if(isObject(%disaster.getTarget())) {
	         %object.banditTarget = %disaster.getTarget().getId();
	         %target = %object.banditTarget;
	      }
	      else {
            %bldgs = new SLGameObjList();
            slgGetServerBuildingListMatch(%disaster.getTarget(), $OST_PLAYER, $BuildingState::Production, %bldgs);
            if(%bldgs.getSize() > 0) {
               %object.banditTarget = %bldgs.getID(0);
               %target = %object.banditTarget;
            }
            %bldgs.delete();
	      }
	   }
	}
	
	%maxHealth = %target.getMaxHealth();
   %datablock = %target.getDataBlock();
   
   // if this is a bank, we will deal half damage to the bank
   if (%datablock == nameToId(Bank))
   {
   	%target.banditHealth = 1 + %target.health - %maxHealth / 2;
   	if (%target.banditHealth < 0)
   	{
   	   %target.banditHealth = 0;
   	   %target.banditSteal = true;
   	}
   }
   else
   {
      %target.banditHealth = 0;
      %target.banditSteal = false;
   }
}

function AISMN_BanditAttackInitialize::OnExit(%this, %data)
{
}

function AISMN_BanditAttackInitialize::Update(%this, %data)
{   
   ReturnValue(%data, 0);
}
